local Assets =
{
	Asset("ANIM", "anim/meatchunk.zip"), 
	Asset("IMAGE", "images/inventoryimages/meatchunk.tex"),
    Asset("ATLAS", "images/inventoryimages/meatchunk.xml"),    
}

local function hurtowner(inst, owner)
	if (owner.components.health) then
		owner.components.health:DoDelta(-2,-1)
end
end

local function onequip(inst, owner) 
    if owner:HasTag("antirad") then
	owner.AnimState:OverrideSymbol("swap_body", "meatchunk", "swap_body")
	owner:AddTag("rad")
	owner:AddTag("radsmall")
	else
	owner.AnimState:OverrideSymbol("swap_body", "meatchunk", "swap_body")
	inst.task = inst:DoPeriodicTask(2, hurtowner, nil, owner)
	owner:AddTag("rad")

	end
end


local function onunequip(inst, owner) 
    owner.AnimState:ClearOverrideSymbol("swap_body")
	owner:RemoveTag("rad")
	owner:RemoveTag("radsmall")
	if inst.task ~= nil then
        inst.task:Cancel()
        inst.task = nil
    end
end

local function fn(Sim)
	local inst = CreateEntity()
	inst.entity:AddTransform()
	inst.entity:AddAnimState()

    MakeInventoryPhysics(inst)
    	
    inst.AnimState:SetBank("meatchunk")
    inst.AnimState:SetBuild("meatchunk")
    inst.AnimState:PlayAnimation("idle", false)
		    
	inst:AddComponent("inspectable")
	
    inst:AddComponent("inventoryitem")
	inst.components.inventoryitem.atlasname = "images/inventoryimages/meatchunk.xml"
	
	inst:AddComponent("equippable")
    inst.components.equippable.equipslot = EQUIPSLOTS.BACK or EQUIPSLOTS.BODY
	inst.components.equippable:SetOnEquip( onequip )
    inst.components.equippable:SetOnUnequip( onunequip )
		
	inst:AddComponent("tradable")
    inst.components.tradable.goldvalue = 15
	
	if IsDLCEnabled(0002) then
	
	inst:AddComponent("poisonhealer")
	MakeInventoryFloatable(inst, "anim", "anim")
	inst.components.equippable.poisonblocker = true
	inst.components.equippable.poisongasblocker = true
	end
	
	
    return inst
end


return Prefab( "common/inventory/meatchunk", fn, Assets)

